//================================================================================
// DefaultSkin.
//================================================================================
class defaultskin expands Mutator config(DefaultSkin);

var bool bInitialized;
var config bool bEnabled,bEnableTourn;
var config string SkinName, FaceName;
var config int ModelNum;

struct sPawn
{
	var int	iPlayerID;
	var bool bSkinned;
};

var sPawn ArrPawn[128];

event Spawned()
{
  super.Spawned();
  if (bEnabled) {
  	if ( DeathMatchPlus(Level.Game).bTournament && !bEnableTourn ) {
			log("Tournament Mode, defaultskin mutator disabled.");
			Destroy();
		}
		else { log("Defaultskin mutator enabled."); }
  }
  else { Destroy(); }
}

function PostBeginPlay ()
{
	local int i;
	SaveConfig();
	if ( !bInitialized )
	{
		for (i=0; i<128; i++)
		{
			ArrPawn[i].iPlayerID = -1;
			ArrPawn[i].bSkinned = false;
		}
		bInitialized=True;
	}
	Super.PostBeginPlay();
}

function ModifyPlayer(Pawn Other)
{
	local int iTeam,i;

	if (bEnabled) {
		iTeam = Other.PlayerReplicationInfo.Team;
		i = Other.PlayerReplicationInfo.PlayerID;
		if (!ArrPawn[i].bSkinned) {
			if ( !Other.IsA('Bot') ) {
				Other.SetMultiSkin(Other, ""$SkinName, ""$FaceName, iTeam);
			}
			ArrPawn[i].bSkinned = True;
		}
		Super.ModifyPlayer(Other);
	}
}

function ModifyLogin (out Class<PlayerPawn> SpawnClass, out string Portal, out string Options)
{
	if (bEnabled) {
		switch(ModelNum)
		{
			case 1:
				if (SpawnClass != class'Botpack.TMale1') {
					SpawnClass = class'Botpack.TMale1';
				}
				break;
			case 2:
				if (SpawnClass != class'Botpack.TFemale1') {
					SpawnClass = class'Botpack.TFemale1';
				}
				break;
			case 3:
				if (SpawnClass != class'Botpack.TFemale2') {
					SpawnClass = class'Botpack.TFemale2';
				}
				break;
			case 4:
				if (SpawnClass != class'Botpack.TBoss') {
					SpawnClass = class'Botpack.TBoss';
				}
				break;
			default:
				if (SpawnClass != class'Botpack.TMale2') {
					SpawnClass = class'Botpack.TMale2';
				}
				break;
		}
	}
	if ( NextMutator != None )
	{
		NextMutator.ModifyLogin(SpawnClass,Portal,Options);
	}
}

